import time
import libximc.highlevel as ximc

# Virtual device will be used by default.
# In case you have real hardware, set correct device URI here

device_uri = r"xi-emu:///ABS_PATH/virtual_controller.bin"  # Virtual device
# device_uri = r"xi-com:\\.\COM111"                        # Serial port
# device_uri = "xi-tcp://172.16.130.155"                   # Raw TCP connection

axis = ximc.Axis(device_uri)
axis.open_device()

print("Launch movement...")
axis.command_right()

time.sleep(3)

print("Stop movement")
axis.command_stop()

print("Disconnect device")
axis.close_device()  # It's also called automatically by the garbage collector, so explicit closing is optional

print("Done")